/**
* \file: AudioChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_AUDIOCHANNEL_H
#define CARPLAY_AUDIOCHANNEL_H

#include "AirPlayHeaders.h"
#include "IAudioOutAdapter.h"
#include "IAudioInAdapter.h"
#include "Common.h"
#include "utils/Referencable.h"
#include <memory>

namespace adit { namespace carplay
{

class Session;

class CARPLAY_HIDDEN AudioChannel : public Referencable<AudioChannel, AudioStreamRef>,
    public IAudioOutSource, public IAudioInSink
{
public:
    AudioChannel();
    ~AudioChannel();

    inline Session* GetSession() { return session; }
    inline void SetSession(Session* inSession) { session = inSession; }

    bool Initialize(IConfiguration& inConfig);

    bool Prepare(AudioChannelType inChannelType, bool inHasInput, AudioFormatStruct inFormat,
            const std::string& inAudioType);
    bool Start();
    bool Stop();
    void Flush();

    inline int64_t GetLatencyMs() const { return latencyMs; }

    inline void SetInputCallback(AudioStreamInputCallback_f inCallback, void* inContext)
    {
        inputCallback = inCallback;
        inputContext = inContext;
    }

    inline void SetOutputCallback(AudioStreamOutputCallback_f inCallback, void* inContext)
    {
        outputCallback = inCallback;
        outputContext = inContext;
    }

private:
    // IAudioOutSource
    void Read(const Samples& inSamples);
    // IAudioInSink
    void Write(const Samples& inSamples);

private:
    Session* session;
    IConfiguration* config;
    std::unique_ptr<IAudioOutAdapter> out;
    std::unique_ptr<IAudioInAdapter> in;
    bool hasInput;
    int latencyMs;
    AudioFormatStruct format;
    AudioChannelType channel;
    bool verbose;

    AudioStreamInputCallback_f inputCallback;
    void* inputContext;
    AudioStreamOutputCallback_f outputCallback;
    void* outputContext;

    uint64_t hostStartTime;
    uint64_t hostInStartTime;
    uint32_t sampleNumber;

    uint64_t previousHostTime;
    uint32_t previousSampleTime;
    uint64_t previousWriteHostTime;
    uint32_t previousWriteSampleTime;

    bool firstOutSample;
    bool firstInSample;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_AUDIOCHANNEL_H */
